// Firefox/Chrome compatible popup script
const browser_api = (typeof browser !== 'undefined') ? browser : chrome;

document.getElementById('shareBtn').addEventListener('click', function () {
    const statusDiv = document.getElementById('status');
    statusDiv.textContent = 'Sharing page...';
    statusDiv.className = '';

    // Get user preferences
    const isPublic = document.getElementById('privacyToggle').checked;
    const captureDescription = document.getElementById('captureDescription').checked;

    browser_api.runtime.sendMessage({ 
        action: 'shareCurrentPage',
        options: {
            isPublic: isPublic,
            captureDescription: captureDescription
        }
    }, function (response) {
        if (browser_api.runtime.lastError) {
            statusDiv.textContent = 'Error: ' + browser_api.runtime.lastError.message;
            statusDiv.className = 'error';
        } else {
            statusDiv.textContent = response.message;

            if (response.success) {
                statusDiv.className = 'success';
            } else if (response.rateLimited) {
                statusDiv.className = 'warning';
                // Safely create DOM elements instead of using innerHTML
                statusDiv.textContent = response.message;

                const breakElement = document.createElement('br');
                const smallElement = document.createElement('small');
                smallElement.textContent = 'Kioju limits submissions to prevent spam. Please wait before trying again.';

                statusDiv.appendChild(breakElement);
                statusDiv.appendChild(smallElement);
            } else {
                statusDiv.className = 'error';
            }
        }
    });
});

// Handle options button click
document.getElementById('optionsBtn').addEventListener('click', function () {
    if (browser_api.runtime.openOptionsPage) {
        browser_api.runtime.openOptionsPage();
    } else {
        window.open(browser_api.runtime.getURL('options.html'));
    }
});
